from django.contrib import admin
# Register your models here.
# bot/admin.py
from .models import Customer, Order, Payment

@admin.register(Customer)
class CustomerAdmin(admin.ModelAdmin):
    list_display = ("whatsapp_number", "name", "created_at")


@admin.register(Order)
class OrderAdmin(admin.ModelAdmin):
    list_display = ("id", "customer", "phone_number", "amount", "status", "created_at")
    search_fields = ("id", "phone_number", "customer__whatsapp_number")

@admin.register(Payment)
class PaymentAdmin(admin.ModelAdmin):
    list_display = ("bank_name", "transaction_reference", "amount", "status", "created_at")
    search_fields = ("transaction_reference",)
