import uuid
import time
import requests
from django.conf import settings
from .signer import build_strA, md5_upper, rsa_sign


def create_virtual_account(
    virtual_account_name,
    identity_type,
    license_number,
    customer_name,
    email=None,
    account_reference=None,
    mode = "test"
):
    payload = {
        "requestTime": int(time.time() * 1000),
        "version": "V2.0",
        "nonceStr": uuid.uuid4().hex,
        "virtualAccountName": virtual_account_name,
        "identityType": identity_type,
        "licenseNumber": license_number,
        "customerName": customer_name,
        "email": email,
        "accountReference": account_reference,
    }
    print("Payload for PalmPay virtual account creation:", payload)

    # 1. Build strA
    strA = build_strA(payload)

    # 2. MD5 uppercase
    md5_str = md5_upper(strA)

    # 3. RSA SHA1 Sign
    signature = rsa_sign(
        md5_str,
        (
            settings.PALMPAY_PROD_PRIVATE_KEY
            if mode == "prod"
            else settings.PALMPAY_TEST_PRIVATE_KEY
        ),
    )

    headers = {
        "Authorization": f"Bearer {settings.PALM_PAY_TOKEN if mode == 'prod' else settings.PALM_PAY_TEST_TOKEN}",
        "Signature": signature,
        "countryCode": "NG",
        "Content-Type": "application/json;charset=UTF-8",
    }

    res = requests.post(
        settings.PALMPAY_PROD_URL if mode == "prod" else settings.PALMPAY_TEST_BASE_URL, json=payload, headers=headers, timeout=30
    )
    res.raise_for_status()

    return res.json()
