import hashlib
import base64
from Crypto.PublicKey import RSA
from Crypto.Signature import pkcs1_15
from Crypto.Hash import SHA1


def build_strA(data: dict):
    pairs = []

    for k, v in data.items():
        if v is None or v == "":
            continue
        pairs.append(f"{k}={str(v).strip()}")

    pairs.sort()  # ASCII sort
    return "&".join(pairs)


def md5_upper(text: str):
    return hashlib.md5(text.encode()).hexdigest().upper()


def rsa_sign(md5_str: str, private_key_b64: str):
    key = RSA.import_key(base64.b64decode(private_key_b64))
    h = SHA1.new(md5_str.encode())
    signature = pkcs1_15.new(key).sign(h)
    return base64.b64encode(signature).decode()
