# PalmPay Virtual Account Creation

from django.conf import settings
from aibot.palmpay.client import create_virtual_account


def create_order_virtual_account(customer, order):
    """
    Create a PalmPay virtual account for a specific order.
    This can be used if you want to generate a unique account for each order instead of per customer.
    """
    if customer.palmpay_account_number is None or customer.palmpay_bank_name is None:

        if settings.PALMPAY_MODE == "prod":
            mode = "prod"
            acct = create_virtual_account(
                virtual_account_name="VAC",
                identity_type="company",  # personal / personal_nin / company
                license_number="RC7317687",  # BVN / NIN / CAC
                customer_name=customer.name or customer.whatsapp_number,
                email=customer.email or "Swiftlinkservice@gmail.com",
                account_reference=str(order.ref),
                mode=mode,
            )
        else:
            mode = "test"

            print("Creating PalmPay virtual account in TEST mode...")

            acct = create_virtual_account(
                virtual_account_name="PPTV2",
                identity_type="company",  # personal / personal_nin / company
                license_number="dasd141234114123",  # BVN / NIN / CAC
                customer_name="palmpayTester",
                email="2222@palmpay.com",
                account_reference=str(order.ref),
                mode=mode,
            )

        # acct = create_palmpay_virtual_account(payload, "prod")
        print("PalmPay virtual account response:", acct)
        if acct:
            customer.palmpay_account_number = acct.get("data").get("virtualAccountNo")
            customer.palmpay_bank_name = "Palmpay Bank"
            customer.palmpay_account_ref = acct.get("data").get("accountReference")
            customer.save()


def verify_palmpay_webhook_signature(request):
    """
    Verify the signature of a PalmPay webhook request.
    Currently, this function only logs a warning and returns True.
    Implement the actual signature verification logic as per PalmPay's documentation.
    """
    signature = request.headers.get("X-PalmPay-Signature")
    if not signature:
        return False
    # You should implement the actual signature check here using PalmPay's docs
    # For now, just log and accept
    import logging

    logging.getLogger(__name__).warning(
        "PalmPay webhook signature verification is not implemented!"
    )
    return True
