# Swiftlink API Key
"""
Django settings for app project.

Generated by 'django-admin startproject' using Django 5.2.8.

For more information on this file, see
https://docs.djangoproject.com/en/5.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.2/ref/settings/
"""

import os
from pathlib import Path

import environ

env = environ.Env()
# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent

environ.Env.read_env(os.path.join(BASE_DIR, ".env"), overwrite=True)

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = "django-insecure-v-54y^x)0==s$9%(k!feltm*lt50=h=r!m(=9f#_++d&6npj90"

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ["*"]


# Application definition

INSTALLED_APPS = [
    "django.contrib.admin",
    "django.contrib.auth",
    "django.contrib.contenttypes",
    "django.contrib.sessions",
    "django.contrib.messages",
    "django.contrib.staticfiles",
]

INSTALLED_APPS += ["aibot"]


MIDDLEWARE = [
    "django.middleware.security.SecurityMiddleware",
    "django.contrib.sessions.middleware.SessionMiddleware",
    "django.middleware.common.CommonMiddleware",
    "django.middleware.csrf.CsrfViewMiddleware",
    "django.contrib.auth.middleware.AuthenticationMiddleware",
    "django.contrib.messages.middleware.MessageMiddleware",
    "django.middleware.clickjacking.XFrameOptionsMiddleware",
]

ROOT_URLCONF = "app.urls"

TEMPLATES = [
    {
        "BACKEND": "django.template.backends.django.DjangoTemplates",
        "DIRS": [],
        "APP_DIRS": True,
        "OPTIONS": {
            "context_processors": [
                "django.template.context_processors.request",
                "django.contrib.auth.context_processors.auth",
                "django.contrib.messages.context_processors.messages",
            ],
        },
    },
]

WSGI_APPLICATION = "app.wsgi.application"


# Database
# https://docs.djangoproject.com/en/5.2/ref/settings/#databases

DATABASES = {
    "default": {
        "ENGINE": "django.db.backends.sqlite3",
        "NAME": BASE_DIR / "db.sqlite3",
    }
}


# Password validation
# https://docs.djangoproject.com/en/5.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        "NAME": "django.contrib.auth.password_validation.UserAttributeSimilarityValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.MinimumLengthValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.CommonPasswordValidator",
    },
    {
        "NAME": "django.contrib.auth.password_validation.NumericPasswordValidator",
    },
]


# Internationalization
# https://docs.djangoproject.com/en/5.2/topics/i18n/

LANGUAGE_CODE = "en-us"

TIME_ZONE = "UTC"

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.2/howto/static-files/

STATIC_URL = "static/"

# Default primary key field type
# https://docs.djangoproject.com/en/5.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = "django.db.models.BigAutoField"

# Celery config (example using Redis)
CELERY_BROKER_URL = env("CELERY_BROKER_URL", default="redis://localhost:6379/0")
CELERY_RESULT_BACKEND = env("CELERY_RESULT_BACKEND", default="redis://localhost:6379/1")


WHATSAPP_PHONE_NUMBER_ID= env("WHATSAPP_PHONE_NUMBER_ID")
WHATSAPP_TOKEN = env("WHATSAPP_TOKEN")

VERIFY_TOKEN = env("VERIFY_TOKEN")

PRIVATE_KEY = env("PRIVATE_KEY")
SWIFTLINK_EMAIL = env("SWIFTLINK_EMAIL")
SWIFTLINK_PASSWORD = env("SWIFTLINK_PASSWORD")

PALMPAY_MODE = "test"  # change to "prod" in production

PALMPAY_PROD_URL = env(
    "PALMPAY_PROD_URL",
    default="https://open-gw-prod.palmpay-inc.com/api/v2/virtual/account/label/create",
)
PALMPAY_PROD_PRIVATE_KEY = env("PALMPAY_PROD_PRIVATE_KEY", default="your_prod_private_key_here")
PALM_PAY_TOKEN = env("PALM_PAY_TOKEN")

# TEST
PALMPAY_TEST_BASE_URL = env(
    "PALMPAY_TEST_BASE_URL",
    default="https://open-gw-daily.palmpay-inc.com/api/v2/virtual/account/label/create",
)
PALMPAY_TEST_PRIVATE_KEY = env("PALMPAY_TEST_PRIVATE_KEY")
PALM_PAY_TEST_TOKEN= env("PALM_PAY_TEST_TOKEN")

LOG_DIR = BASE_DIR / "logs"
LOG_DIR.mkdir(exist_ok=True)

LOGGING = {
    "version": 1,
    "disable_existing_loggers": False,
    "formatters": {
        "verbose": {
            "format": "[{asctime}] {levelname} {name} | {message}",
            "style": "{",
        },
        "simple": {
            "format": "{levelname}: {message}",
            "style": "{",
        },
    },
    "handlers": {
        # Log to console
        "console": {
            "class": "logging.StreamHandler",
            "formatter": "verbose",
        },
        # Log to file (rotates daily, keeps 7 days)
        "file": {
            "class": "logging.handlers.TimedRotatingFileHandler",
            "filename": os.path.join(LOG_DIR, "whatsapp.log"),
            "when": "midnight",  # rotate daily
            "interval": 1,
            "backupCount": 7,  # keep 7 days
            "formatter": "verbose",
        },
    },
    "loggers": {
        # Log everything from Django
        "django": {
            "handlers": ["console", "file"],
            "level": "INFO",
            "propagate": True,
        },
        # Your WhatsApp app logger
        "aibot": {  # 👈 change this to match your app name
            "handlers": ["console", "file"],
            "level": "INFO",
            "propagate": False,
        },
    },
    # Optional: root logger (catches everything)
    "root": {
        "handlers": ["console", "file"],
        "level": "INFO",
    },
}
